<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="pageHelp" value="${pageFlow.preferencesHelpURI}" />

<%@include file="notificationTemplate.jspf"%>

<div class="mhv-printer-friendly-container">
    <a href="${pageHelp}" target="_mhvHelp">
    	Help 
    	<img src="${pageContext.request.contextPath}/resources/images/icon_help.gif" 
    	     alt="View Help File" border="0" />
    </a>
</div>

<h2>
<nobr>
Personal Health Record of <netui:content value="${pageFlow.fullPatientName}"/>
</nobr>
</h2>


<h2>Wellness Reminders Preferences</h2>

<p>
	You are viewing your VA health care locations. Your Wellness Reminders
	will be displayed based on the VA facilities you select below.
</p>

<netui:form action="savePreferences">

	<table border="0" cellpadding="0" cellspacing="0" class="mhv-detail-listing" summary="Detailed information on the {0} entry you've selected.">
		<tr>
			<th scope="row" class="midAlign"><netui:label value="Locations:" title="Locations:" /></th>
			<td>
			   <table cellpadding="0" cellspacing="0" border="0" class="noBorder">
					<tr>
						<td width="20" valign="middle" align="left">
						  <netui:checkBoxGroup dataSource="pageFlow.selectedFacilities" defaultValue="${pageFlow.availableFacilities}" optionsDataSource="${pageFlow.availableFacilities}" />
						</td>
					</tr>

				</table>
			</td>
		</tr>
	</table>   
        
    <div class="mhv-button-container-align-left">
    	<netui:anchor formSubmit="true" styleClass="mhv-input-button">Save Preferences
    	   <netui:parameter name="fromPage" value="${pageFlow.fromPage}"/>
    	</netui:anchor>
    	
    	<c:if test="${pageFlow.fromPage == 'Unresolved'}" >
			<netui:anchor action="viewNonCompletedStatusSummary" styleClass="mhv-input-button">Go To Reminders List</netui:anchor>
		</c:if>
    	<c:if test="${pageFlow.fromPage == 'resolved'}" >
			<netui:anchor action="viewCompletedStatusSummary" styleClass="mhv-input-button">Go To Reminders List</netui:anchor>
		</c:if>
			
	</div>
</netui:form>

<%@ include file="../../common/pageFooter.jspf" %>